import mediapipe as mp
from mediapipe.tasks import python
from mediapipe.tasks.python import vision

import cv2

model_path = "/Users/vpaudel343/OneDrive - Plaksha University/gym-exercise-feedback/experiments/pose_landmarker_full.task"

BaseOptions = mp.tasks.BaseOptions
PoseLandmarker = mp.tasks.vision.PoseLandmarker
PoseLandmarkerOptions = mp.tasks.vision.PoseLandmarkerOptions
VisionRunningMode = mp.tasks.vision.RunningMode

# Create a pose landmarker instance with the video mode:
options = PoseLandmarkerOptions(
    base_options=BaseOptions(model_asset_path=model_path),
    running_mode=VisionRunningMode.VIDEO,
)

with PoseLandmarker.create_from_options(options) as landmarker:
    # The landmarker is initialized. Use it here.
    # ...

    # Use OpenCV’s VideoCapture to load the input video.
    video_path = "your_video.mp4"
    cap = cv2.VideoCapture(video_path)

    # Get the frame rate of the video
    frame_rate = cap.get(cv2.CAP_PROP_FPS)

    while True:
        ret, frame = cap.read()
        if not ret:
            break

        # Convert the frame received from OpenCV to a MediaPipe Image object.
        numpy_frame_from_opencv = frame
        mp_image = mp.Image(
            image_format=mp.ImageFormat.SRGB, data=numpy_frame_from_opencv
        )
        pose_landmarker_result = landmarker.detect_for_video(
            mp_image, frame_timestamp_ms
        )

        # Now, you can use 'mp_image' for pose estimation or any other tasks with MediaPipe.

        # If you want to perform pose estimation with the 'landmarker' instance, you can do:
        results = landmarker.process(mp_image)

        # Continue processing the results as needed.

        # Display the annotated frame, if desired
        # (e.g., using mp.solutions.drawing_utils to draw landmarks)

        if cv2.waitKey(1) & 0xFF == ord("q"):
            break

    # Release the video capture and close the OpenCV windows
    cap.release()
    cv2.destroyAllWindows()
